#include "p263_huffman.h"


/// Macroblock type & Coded Block Pattern for Chrominance (MCBPC)

huffman_code_t vlc_mcbpc_ipictures[VLC_MCBPC_IPICTURES_NUM] = {
  { 0, {{ 1, 0x1 }} }, //           1
  { 1, {{ 3, 0x1 }} }, //         001
  { 2, {{ 3, 0x2 }} }, //         010
  { 3, {{ 3, 0x3 }} }, //         011
  { 4, {{ 4, 0x1 }} }, //        0001
  { 5, {{ 6, 0x1 }} }, //     00 0001
  { 6, {{ 6, 0x2 }} }, //     00 0010
  { 7, {{ 6, 0x3 }} }, //     00 0011
  { 8, {{ 9, 0x1 }} }, // 0 0000 0001
};

huffman_tree_t* vlc_mcbpc_ipictures_tree = NULL;

p263_mcbpc_t mcbpc_ipictures[VLC_MCBPC_IPICTURES_NUM] = {
  { 3, 0 },
  { 3, 1 },
  { 3, 2 },
  { 3, 3 },
  { 4, 0 },
  { 4, 1 },
  { 4, 2 },
  { 4, 3 },
  { 6, 0 },
};


/// Coded Block Pattern for luminance (CBPY)

huffman_code_t   vlc_cbpy_standard[VLC_CBPY_STANDARD_NUM] = {
  {  0, {{ 4, 0x3 }} }, //    0011
  {  1, {{ 5, 0x5 }} }, //  0 0101
  {  2, {{ 5, 0x4 }} }, //  0 0100
  {  3, {{ 4, 0x9 }} }, //    1001
  {  4, {{ 5, 0x3 }} }, //  0 0011
  {  5, {{ 4, 0x7 }} }, //    0111
  {  6, {{ 6, 0x2 }} }, // 00 0010
  {  7, {{ 4, 0xB }} }, //    1011
  {  8, {{ 5, 0x2 }} }, //  0 0010
  {  9, {{ 6, 0x3 }} }, // 00 0011
  { 10, {{ 4, 0x5 }} }, //    0101
  { 11, {{ 4, 0xA }} }, //    1010
  { 12, {{ 4, 0x4 }} }, //    0100
  { 13, {{ 4, 0x8 }} }, //    1000
  { 14, {{ 4, 0x6 }} }, //    0110
  { 15, {{ 2, 0x3 }} }, //      11
};

huffman_tree_t*  vlc_cbpy_standard_tree = NULL;

p263_cbpy_t cbpy_standard[VLC_CBPY_STANDARD_NUM - 1] = {
  { CBPY_MAKE(0, 0), CBPY_MAKE( 3, 3) },
  { CBPY_MAKE(0, 1), CBPY_MAKE( 3, 2) },
  { CBPY_MAKE(0, 2), CBPY_MAKE( 3, 1) },
  { CBPY_MAKE(0, 3), CBPY_MAKE( 3, 0) },
  { CBPY_MAKE(1, 0), CBPY_MAKE( 2, 3) },
  { CBPY_MAKE(1, 1), CBPY_MAKE( 2, 2) },
  { CBPY_MAKE(1, 2), CBPY_MAKE( 2, 1) },
  { CBPY_MAKE(1, 3), CBPY_MAKE( 2, 0) },
  { CBPY_MAKE(2, 0), CBPY_MAKE( 1, 3) },
  { CBPY_MAKE(2, 1), CBPY_MAKE( 1, 2) },
  { CBPY_MAKE(2, 2), CBPY_MAKE( 1, 1) },
  { CBPY_MAKE(2, 3), CBPY_MAKE( 1, 0) },
  { CBPY_MAKE(3, 0), CBPY_MAKE( 0, 3) },
  { CBPY_MAKE(3, 1), CBPY_MAKE( 0, 2) },
  { CBPY_MAKE(3, 2), CBPY_MAKE( 0, 1) },
};

// Transform Coefficient (TCOEF)

huffman_code_t vlc_tcoeff[VLC_TCOEFF_NUM] = {
  {  0, {{  2, 0x02 }} }, //  3             10 s
  {  1, {{  4, 0x0F }} }, //  5           1111 s
  {  2, {{  6, 0x15 }} }, //  7        01 0101 s
  {  3, {{  7, 0x17 }} }, //  8       001 0111 s
  {  4, {{  8, 0x1F }} }, //  9      0001 1111 s
  {  5, {{  9, 0x25 }} }, // 10    0 0010 0101 s
  {  6, {{  9, 0x24 }} }, // 10    0 0010 0100 s
  {  7, {{ 10, 0x21 }} }, // 11   00 0010 0001 s
  {  8, {{ 10, 0x20 }} }, // 11   00 0010 0000 s
  {  9, {{ 11, 0x07 }} }, // 12  000 0000 0111 s
  { 10, {{ 11, 0x06 }} }, // 12  000 0000 0110 s
  { 11, {{ 11, 0x20 }} }, // 12  000 0010 0000 s
  { 12, {{  3, 0x06 }} }, //  4            110 s
  { 13, {{  6, 0x14 }} }, //  7        01 0100 s
  { 14, {{  8, 0x1E }} }, //  9      0001 1110 s
  { 15, {{ 10, 0x0F }} }, // 11   00 0000 1111 s
  { 16, {{ 11, 0x21 }} }, // 12  000 0010 0001 s
  { 17, {{ 12, 0x50 }} }, // 13 0000 0101 0000 s
  { 18, {{  4, 0x0E }} }, //  5           1110 s
  { 19, {{  8, 0x1D }} }, //  9      0001 1101 s
  { 20, {{ 10, 0x0E }} }, // 11   00 0000 1110 s
  { 21, {{ 12, 0x51 }} }, // 13 0000 0101 0001 s
  { 22, {{  5, 0x0D }} }, //  6         0 1101 s
  { 23, {{  9, 0x23 }} }, // 10    0 0010 0011 s
  { 24, {{ 10, 0x0D }} }, // 11   00 0000 1101 s
  { 25, {{  5, 0x0C }} }, //  6         0 1100 s
  { 26, {{  9, 0x22 }} }, // 10    0 0010 0010 s
  { 27, {{ 12, 0x52 }} }, // 13 0000 0101 0010 s
  { 28, {{  5, 0x0B }} }, //  6         0 1011 s
  { 29, {{ 10, 0x0C }} }, // 11   00 0000 1100 s
  { 30, {{ 12, 0x53 }} }, // 13 0000 0101 0011 s
  { 31, {{  6, 0x13 }} }, //  7        01 0011 s
  { 32, {{ 10, 0x0B }} }, // 11   00 0000 1011 s
  { 33, {{ 12, 0x54 }} }, // 13 0000 0101 0100 s
  { 34, {{  6, 0x12 }} }, //  7        01 0010 s
  { 35, {{ 10, 0x0A }} }, // 11   00 0000 1010 s
  { 36, {{  6, 0x11 }} }, //  7        01 0001 s
  { 37, {{ 10, 0x09 }} }, // 11   00 0000 1001 s
  { 38, {{  6, 0x10 }} }, //  7        01 0000 s
  { 39, {{ 10, 0x08 }} }, // 11   00 0000 1000 s
  { 40, {{  7, 0x16 }} }, //  8       001 0110 s
  { 41, {{ 12, 0x55 }} }, // 13 0000 0101 0101 s
  { 42, {{  7, 0x15 }} }, //  8       001 0101 s
  { 43, {{  7, 0x14 }} }, //  8       001 0100 s
  { 44, {{  8, 0x1C }} }, //  9      0001 1100 s
  { 45, {{  8, 0x1B }} }, //  9      0001 1011 s
  { 46, {{  9, 0x21 }} }, // 10    0 0010 0001 s
  { 47, {{  9, 0x20 }} }, // 10    0 0010 0000 s
  { 48, {{  9, 0x1F }} }, // 10    0 0001 1111 s
  { 49, {{  9, 0x1E }} }, // 10    0 0001 1110 s
  { 50, {{  9, 0x1D }} }, // 10    0 0001 1101 s
  { 51, {{  9, 0x1C }} }, // 10    0 0001 1100 s
  { 52, {{  9, 0x1B }} }, // 10    0 0001 1011 s
  { 53, {{  9, 0x1A }} }, // 10    0 0001 1010 s
  { 54, {{ 11, 0x22 }} }, // 12  000 0010 0010 s
  { 55, {{ 11, 0x23 }} }, // 12  000 0010 0011 s
  { 56, {{ 12, 0x56 }} }, // 13 0000 0101 0110 s
  { 57, {{ 12, 0x57 }} }, // 13 0000 0101 0111 s
  { 58, {{  4, 0x07 }} }, //  5           0111 s
  { 59, {{  9, 0x19 }} }, // 10    0 0001 1001 s
  { 60, {{ 11, 0x05 }} }, // 12  000 0000 0101 s
  { 61, {{  6, 0x0F }} }, //  7        00 1111 s
  { 62, {{ 11, 0x04 }} }, // 12  000 0000 0100 s
  { 63, {{  6, 0x0E }} }, //  7        00 1110 s
  { 64, {{  6, 0x0D }} }, //  7        00 1101 s
  { 65, {{  6, 0x0C }} }, //  7        00 1100 s
  { 66, {{  7, 0x13 }} }, //  8       001 0011 s
  { 67, {{  7, 0x12 }} }, //  8       001 0010 s
  { 68, {{  7, 0x11 }} }, //  8       001 0001 s
  { 69, {{  7, 0x10 }} }, //  8       001 0000 s
  { 70, {{  8, 0x1A }} }, //  9      0001 1010 s
  { 71, {{  8, 0x19 }} }, //  9      0001 1001 s
  { 72, {{  8, 0x18 }} }, //  9      0001 1000 s
  { 73, {{  8, 0x17 }} }, //  9      0001 0111 s
  { 74, {{  8, 0x16 }} }, //  9      0001 0110 s
  { 75, {{  8, 0x15 }} }, //  9      0001 0101 s
  { 76, {{  8, 0x14 }} }, //  9      0001 0100 s
  { 77, {{  8, 0x13 }} }, //  9      0001 0011 s
  { 78, {{  9, 0x18 }} }, // 10    0 0001 1000 s
  { 79, {{  9, 0x17 }} }, // 10    0 0001 0111 s
  { 80, {{  9, 0x16 }} }, // 10    0 0001 0110 s
  { 81, {{  9, 0x15 }} }, // 10    0 0001 0101 s
  { 82, {{  9, 0x14 }} }, // 10    0 0001 0100 s
  { 83, {{  9, 0x13 }} }, // 10    0 0001 0011 s
  { 84, {{  9, 0x12 }} }, // 10    0 0001 0010 s
  { 85, {{  9, 0x11 }} }, // 10    0 0001 0001 s
  { 86, {{ 10, 0x07 }} }, // 11   00 0000 0111 s
  { 87, {{ 10, 0x06 }} }, // 11   00 0000 0110 s
  { 88, {{ 10, 0x05 }} }, // 11   00 0000 0101 s
  { 89, {{ 10, 0x04 }} }, // 11   00 0000 0100 s
  { 90, {{ 11, 0x24 }} }, // 12  000 0010 0100 s
  { 91, {{ 11, 0x25 }} }, // 12  000 0010 0101 s
  { 92, {{ 11, 0x26 }} }, // 12  000 0010 0110 s
  { 93, {{ 11, 0x27 }} }, // 12  000 0010 0111 s
  { 94, {{ 12, 0x58 }} }, // 13 0000 0101 1000 s
  { 95, {{ 12, 0x59 }} }, // 13 0000 0101 1001 s
  { 96, {{ 12, 0x5A }} }, // 13 0000 0101 1010 s
  { 97, {{ 12, 0x5B }} }, // 13 0000 0101 1011 s
  { 98, {{ 12, 0x5C }} }, // 13 0000 0101 1100 s
  { 99, {{ 12, 0x5D }} }, // 13 0000 0101 1101 s
  {100, {{ 12, 0x5E }} }, // 13 0000 0101 1110 s
  {101, {{ 12, 0x5F }} }, // 13 0000 0101 1111 s
  {102, {{  7, 0x03 }} }, //  7       000 0011
};

huffman_tree_t* vlc_tcoeff_tree = NULL;

p263_tcoeff_t tcoeff[VLC_TCOEFF_NUM] = {
  {  0,  1,  0 },
  {  0,  2,  0 },
  {  0,  3,  0 },
  {  0,  4,  0 },
  {  0,  5,  0 },
  {  0,  6,  0 },
  {  0,  7,  0 },
  {  0,  8,  0 },
  {  0,  9,  0 },
  {  0, 10,  0 },
  {  0, 11,  0 },
  {  0, 11,  0 },

  {  1,  1,  0 },
  {  1,  2,  0 },
  {  1,  3,  0 },
  {  1,  4,  0 },
  {  1,  5,  0 },
  {  1,  6,  0 },

  {  2,  1,  0 },
  {  2,  2,  0 },
  {  2,  3,  0 },
  {  2,  4,  0 },

  {  3,  1,  0 },
  {  3,  2,  0 },
  {  3,  3,  0 },

  {  4,  1,  0 },
  {  4,  2,  0 },
  {  4,  3,  0 },

  {  5,  1,  0 },
  {  5,  2,  0 },
  {  5,  3,  0 },

  {  6,  1,  0 },
  {  6,  2,  0 },
  {  6,  3,  0 },

  {  7,  1,  0 },
  {  7,  2,  0 },

  {  8,  1,  0 },
  {  8,  2,  0 },

  {  9,  1,  0 },
  {  9,  2,  0 },

  { 10,  1,  0 },
  { 10,  2,  0 },

  { 11,  1,  0 },

  { 12,  1,  0 },

  { 13,  1,  0 },

  { 14,  1,  0 },

  { 15,  1,  0 },

  { 16,  1,  0 },

  { 17,  1,  0 },

  { 18,  1,  0 },

  { 19,  1,  0 },

  { 20,  1,  0 },

  { 21,  1,  0 },

  { 22,  1,  0 },

  { 23,  1,  0 },

  { 24,  1,  0 },

  { 25,  1,  0 },

  { 26,  1,  0 },

  {  0,  1,  1 },
  {  0,  2,  1 },
  {  0,  3,  1 },

  {  1,  1,  1 },
  {  1,  2,  1 },

  {  2,  1,  1 },

  {  3,  1,  1 },

  {  4,  1,  1 },

  {  5,  1,  1 },

  {  6,  1,  1 },

  {  7,  1,  1 },

  {  8,  1,  1 },

  {  9,  1,  1 },

  { 10,  1,  1 },

  { 11,  1,  1 },

  { 12,  1,  1 },

  { 13,  1,  1 },

  { 14,  1,  1 },

  { 15,  1,  1 },

  { 16,  1,  1 },

  { 17,  1,  1 },

  { 18,  1,  1 },

  { 19,  1,  1 },

  { 20,  1,  1 },

  { 21,  1,  1 },

  { 22,  1,  1 },

  { 23,  1,  1 },

  { 24,  1,  1 },

  { 25,  1,  1 },

  { 26,  1,  1 },

  { 27,  1,  1 },

  { 28,  1,  1 },

  { 29,  1,  1 },

  { 30,  1,  1 },

  { 31,  1,  1 },

  { 32,  1,  1 },

  { 33,  1,  1 },

  { 34,  1,  1 },

  { 35,  1,  1 },

  { 36,  1,  1 },

  { 37,  1,  1 },

  { 38,  1,  1 },

  { 39,  1,  1 },

  { 40,  1,  1 },

  {  0,  0,  VLC_TCOEFF_ESCAPE },
};


huffman_code_t mvd_vlc[MVD_VLC_NUM] = {
  {  0,  {{ 13, 0x05 }} }, // 13 0 0000 0000 0101
  {  1,  {{ 13, 0x07 }} }, // 13 0 0000 0000 0111
  {  2,  {{ 12, 0x05 }} }, // 12   0000 0000 0101
  {  3,  {{ 12, 0x07 }} }, // 12   0000 0000 0111
  {  4,  {{ 12, 0x09 }} }, // 12   0000 0000 1001
  {  5,  {{ 12, 0x0B }} }, // 12   0000 0000 1011
  {  6,  {{ 12, 0x0D }} }, // 12   0000 0000 1101
  {  7,  {{ 12, 0x0F }} }, // 12   0000 0000 1111
  {  8,  {{ 11, 0x09 }} }, // 11    000 0000 1001
  {  9,  {{ 11, 0x0B }} }, // 11    000 0000 1011
  {  10, {{ 11, 0x0D }} }, // 11    000 0000 1101
  {  11, {{ 11, 0x0F }} }, // 11    000 0000 1111
  {  12, {{ 11, 0x11 }} }, // 11    000 0001 0001
  {  13, {{ 11, 0x13 }} }, // 11    000 0001 0011
  {  14, {{ 11, 0x15 }} }, // 11    000 0001 0101
  {  15, {{ 11, 0x17 }} }, // 11    000 0001 0111
  {  16, {{ 11, 0x19 }} }, // 11    000 0001 1001
  {  17, {{ 11, 0x1B }} }, // 11    000 0001 1011
  {  18, {{ 11, 0x1D }} }, // 11    000 0001 1101
  {  19, {{ 11, 0x1F }} }, // 11    000 0001 1111
  {  20, {{ 11, 0x21 }} }, // 11    000 0010 0001
  {  21, {{ 11, 0x23 }} }, // 11    000 0010 0011
  {  22, {{ 10, 0x13 }} }, // 10     00 0001 0011
  {  23, {{ 10, 0x15 }} }, // 10     00 0001 0101
  {  24, {{ 10, 0x17 }} }, // 10     00 0001 0111
  {  25, {{  8, 0x07 }} }, //  8        0000 0111
  {  26, {{  8, 0x09 }} }, //  8        0000 1001
  {  27, {{  8, 0x0B }} }, //  8        0000 1011
  {  28, {{  7, 0x07 }} }, //  7         000 0111
  {  29, {{  5, 0x03 }} }, //  5           0 0011
  {  30, {{  4, 0x03 }} }, //  4             0011
  {  31, {{  3, 0x03 }} }, //  3              011
  {  32, {{  1, 0x01 }} }, //  1                1
  {  33, {{  3, 0x02 }} }, //  3              010
  {  34, {{  4, 0x02 }} }, //  4             0010
  {  35, {{  5, 0x02 }} }, //  5           0 0010
  {  36, {{  7, 0x06 }} }, //  7         000 0110
  {  37, {{  8, 0x0A }} }, //  8        0000 1010
  {  38, {{  8, 0x08 }} }, //  8        0000 1000
  {  39, {{  8, 0x06 }} }, //  8        0000 0110
  {  40, {{ 10, 0x16 }} }, // 10     00 0001 0110
  {  41, {{ 10, 0x14 }} }, // 10     00 0001 0100
  {  42, {{ 10, 0x12 }} }, // 10     00 0001 0010
  {  43, {{ 11, 0x22 }} }, // 11    000 0010 0010
  {  44, {{ 11, 0x20 }} }, // 11    000 0010 0000
  {  45, {{ 11, 0x1E }} }, // 11    000 0001 1110
  {  46, {{ 11, 0x1C }} }, // 11    000 0001 1100
  {  47, {{ 11, 0x1A }} }, // 11    000 0001 1010
  {  48, {{ 11, 0x18 }} }, // 11    000 0001 1000
  {  49, {{ 11, 0x16 }} }, // 11    000 0001 0110
  {  50, {{ 11, 0x14 }} }, // 11    000 0001 0100
  {  51, {{ 11, 0x12 }} }, // 11    000 0001 0010
  {  52, {{ 11, 0x10 }} }, // 11    000 0001 0000
  {  53, {{ 11, 0x0E }} }, // 11    000 0000 1110
  {  54, {{ 11, 0x0C }} }, // 11    000 0000 1100
  {  55, {{ 11, 0x0A }} }, // 11    000 0000 1010
  {  56, {{ 11, 0x08 }} }, // 11    000 0000 1000
  {  57, {{ 12, 0x0E }} }, // 12   0000 0000 1110
  {  58, {{ 12, 0x0C }} }, // 12   0000 0000 1100
  {  59, {{ 12, 0x0A }} }, // 12   0000 0000 1010
  {  60, {{ 12, 0x08 }} }, // 12   0000 0000 1000
  {  61, {{ 12, 0x06 }} }, // 12   0000 0000 0110
  {  62, {{ 12, 0x04 }} }, // 12   0000 0000 0100
  {  63, {{ 13, 0x06 }} }, // 13  00000 0000 0110
};

huffman_tree_t*  mvd_vlc_tree = NULL;

#define MAKE_WORD(a) ((int)(a*65536.0f))

p263_mvd_t mvd[MVD_VLC_NUM] = {
  { MAKE_WORD(-16  ), MAKE_WORD( 16  ) },
  { MAKE_WORD(-15.5), MAKE_WORD( 16.5) },
  { MAKE_WORD(-15  ), MAKE_WORD( 17  ) },
  { MAKE_WORD(-14.5), MAKE_WORD( 17.5) },
  { MAKE_WORD(-14  ), MAKE_WORD( 18  ) },
  { MAKE_WORD(-13.5), MAKE_WORD( 18.5) },
  { MAKE_WORD(-13  ), MAKE_WORD( 19  ) },
  { MAKE_WORD(-12.5), MAKE_WORD( 19.5) },
  { MAKE_WORD(-12  ), MAKE_WORD( 20  ) },
  { MAKE_WORD(-11.5), MAKE_WORD( 20.5) },
  { MAKE_WORD(-11  ), MAKE_WORD( 21  ) },
  { MAKE_WORD(-10.5), MAKE_WORD( 21.5) },
  { MAKE_WORD(-10  ), MAKE_WORD( 22  ) },
  { MAKE_WORD(-9.5 ), MAKE_WORD( 22.5) },
  { MAKE_WORD(-9   ), MAKE_WORD( 23  ) },
  { MAKE_WORD(-8.5 ), MAKE_WORD( 23.5) },
  { MAKE_WORD(-8   ), MAKE_WORD( 24  ) },
  { MAKE_WORD(-7.5 ), MAKE_WORD( 24.5) },
  { MAKE_WORD(-7   ), MAKE_WORD( 25  ) },
  { MAKE_WORD(-6.5 ), MAKE_WORD( 25.5) },
  { MAKE_WORD(-6   ), MAKE_WORD( 26  ) },
  { MAKE_WORD(-5.5 ), MAKE_WORD( 26.5) },
  { MAKE_WORD(-5   ), MAKE_WORD( 27  ) },
  { MAKE_WORD(-4.5 ), MAKE_WORD( 27.5) },
  { MAKE_WORD(-4   ), MAKE_WORD( 28  ) },
  { MAKE_WORD(-3.5 ), MAKE_WORD( 28.5) },
  { MAKE_WORD(-3   ), MAKE_WORD( 29  ) },
  { MAKE_WORD(-2.5 ), MAKE_WORD( 29.5) },
  { MAKE_WORD(-2   ), MAKE_WORD( 30  ) },
  { MAKE_WORD(-1.5 ), MAKE_WORD( 30.5) },
  { MAKE_WORD(-1   ), MAKE_WORD( 31  ) },
  { MAKE_WORD(-0.5 ), MAKE_WORD( 31.5) },
  { MAKE_WORD( 0   ), MAKE_WORD(  0  ) },
  { MAKE_WORD( 0.5 ), MAKE_WORD(-31.5) },
  { MAKE_WORD( 1   ), MAKE_WORD(-31  ) },
  { MAKE_WORD( 1.5 ), MAKE_WORD(-30.5) },
  { MAKE_WORD( 2   ), MAKE_WORD(-30  ) },
  { MAKE_WORD( 2.5 ), MAKE_WORD(-29.5) },
  { MAKE_WORD( 3   ), MAKE_WORD(-29  ) },
  { MAKE_WORD( 3.5 ), MAKE_WORD(-28.5) },
  { MAKE_WORD( 4   ), MAKE_WORD(-28  ) },
  { MAKE_WORD( 4.5 ), MAKE_WORD(-27.5) },
  { MAKE_WORD( 5   ), MAKE_WORD(-27  ) },
  { MAKE_WORD( 5.5 ), MAKE_WORD(-26.5) },
  { MAKE_WORD( 6   ), MAKE_WORD(-26  ) },
  { MAKE_WORD( 6.5 ), MAKE_WORD(-25.5) },
  { MAKE_WORD( 7   ), MAKE_WORD(-25  ) },
  { MAKE_WORD( 7.5 ), MAKE_WORD(-24.5) },
  { MAKE_WORD( 8   ), MAKE_WORD(-24  ) },
  { MAKE_WORD( 8.5 ), MAKE_WORD(-23.5) },
  { MAKE_WORD( 9   ), MAKE_WORD(-23  ) },
  { MAKE_WORD( 9.5 ), MAKE_WORD(-22.5) },
  { MAKE_WORD( 10  ), MAKE_WORD(-22  ) },
  { MAKE_WORD( 10.5), MAKE_WORD(-21.5) },
  { MAKE_WORD( 11  ), MAKE_WORD(-21  ) },
  { MAKE_WORD( 11.5), MAKE_WORD(-20.5) },
  { MAKE_WORD( 12  ), MAKE_WORD(-20  ) },
  { MAKE_WORD( 12.5), MAKE_WORD(-19.5) },
  { MAKE_WORD( 13  ), MAKE_WORD(-19  ) },
  { MAKE_WORD( 13.5), MAKE_WORD(-18.5) },
  { MAKE_WORD( 14  ), MAKE_WORD(-18  ) },
  { MAKE_WORD( 14.5), MAKE_WORD(-17.5) },
  { MAKE_WORD( 15  ), MAKE_WORD(-17  ) },
  { MAKE_WORD( 15.5), MAKE_WORD(-16.5) },
};
